//Program Title: To study and perform spatial and frequency domain image enhancement techniques.
//Program Description: This scilab code is used to perform image enhancement using Low pass filter, High pass filter, High boost filter, Gaussian filter and Histogram Equalization.

//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit
//Scilab version: 6.0.1 (Tested on 64 bit version)
//Toolbox used: Image Processing and Computer Vision Toolbox (version 2.0)
//Reference book name : Digital Image Processing book (author : Rafael C.Gonzalez and Richard E.Woods)

clear;
clc;
clear all;
close;

img = imread("lena.jpg"); // input image --> lena.jpg
img_gray = rgb2gray(img);
img_gray = imresize(img_gray, [256, 256]);
figure(); xname("Gray image");
imshow(img_gray);

// Creating LPF mask_LPF
mask_LPF = ones(3,3)/9;
disp(mask_LPF);

img_LPF = conv2(double(img_gray), mask_LPF);
img_LPF = uint8(img_LPF)
figure(); xname("Image after LPF");
imshow(uint8(img_LPF));

// Creating HPF mask_HPF
mask_HPF = ones(3,3);
mask_HPF = mask_HPF*-1;
mask_HPF(2,2) = mask_HPF(2,2) + 9
disp(mask_HPF);
mask_HPF  = mask_HPF/9
disp(mask_HPF);

img_HPF = conv2(double(img_gray), mask_HPF);
figure(); xname("Image after HPF");

// To make negative numbers zeros
img_HPF = (abs(img_HPF) + img_HPF)/2;
img_HPF = uint8(img_HPF)
imshow(uint8(img_HPF));

//High Boost Filter
//Create HBF mask
mask_HBF = ones(3,3);
mask_HBF = mask_HBF*-1;
A = 5;
mask_HBF(2,2) = 8 + A
disp(mask_HBF);
mask_HBF  = mask_HBF/9
disp(mask_HBF);
[m,n] = size(img_gray)
padded_img = zeros(m+2,n+2);

//create image with zeros padded at the boundaries
u=2;
v=2;
for x=1:m
    for y=1:n
        padded_img(u,v) = img_gray(x,y);
        v = v+1;
    end
    u = u+1;
    v = 2;
    
end

hbf = zeros(m+2,n+2);

//applying the HBF mask on the image
u=1;v=1;
for x=2:m+1
    for y=2:n+1
        hbf(x,y) = padded_img(x-1,y-1)*mask_HBF(1,1) + padded_img(x-1,y)*mask_HBF(1,2) + padded_img(x-1,y+1)*mask_HBF(1,3) +padded_img(x,y-1)*mask_HBF(2,1) +padded_img(x,y)*mask_HBF(2,2) +padded_img(x,y+1)*mask_HBF(2,3) +padded_img(x+1,y-1)*mask_HBF(3,1) +padded_img(x+1,y)*mask_HBF(3,2) +padded_img(x+1,y+1)*mask_HBF(3,3) ;
        v=v+1;
    end  
    u=u+1;  
end

//remove padded zeros
for x=2:m+1
    for y=2:n+1
        hbf_img(x-1,y-1) = hbf(x,y);
    end
end

//convert all negative values to zeros
hbf_img = (abs(hbf_img)+hbf_img)/2;

//Display HBF image
figure(); 
xname("HBF image");
imshow(uint8(hbf_img));


//Gaussian Filtering
N = 3
sigma = 1

ind = -floor(N/2) : floor(N/2);
disp(ind)
[X Y] = meshgrid(ind, ind)

//create gaussian Mask
mask_gaussian = (1/(2*%pi*sigma))*exp(-(X.^2 + Y.^2) / (2*sigma*sigma));
mask_gaussian = [[1, 2 , 1];[2,4,2];[1,2,1]];
disp(mask_gaussian)
// Normalize so that total area (sum of all weights) is 1
mask_gaussian = mask_gaussian / sum(mask_gaussian(:));
disp(mask_gaussian)

img_gaussian = conv2(double(img_gray), mask_gaussian);
figure(); 
xname("Image after Gaussian Filter");
imshow(uint8(img_gaussian));
imwrite(uint8(img_gaussian),'noise_filtered_img_gaussian.jpg');



// HISTOGRAM EQUALIZATION
[count, cells]=imhist(img_gray);
k=256
count = count/(k*k);
x= [0:1:(k-1)]';
figure();
title('original Histogram');
plot2d3(x,[count]);

cdf = zeros(k,1);
sum1=0;
for m= 1:k
    sum1 = sum1 + count(m,1);
    cdf(m,1)= sum1;
end

cdf_multiplied = cdf*(k-1);
for m= 1:k
    new_gray_levels(m,1) = round(cdf_multiplied(m,1));
end

j= new_gray_levels(1,1);
for m = 1:k
    if m==1 then
        pix(m,1) = count(m,1)*k*k;
    end
    if m ~= 1
        if j == new_gray_levels(m,1)
            pix(m,1) = 0;
        else
            pix(m,1) = count(m,1)*k*k;
            j= new_gray_levels(m,1);
        end
    end
end

for m=1:k
    if pix(m,1)==0
        var = m
        while pix(var,1)==0
            if var>1
                var = var -1
            else
                break
            end
        end
        pix(var,1)= pix(var,1)+count(m,1)*k*k;
    end
end

res = zeros(k,k)
for m = 1:k
    for n = 1:k
        old = img_gray(m,n)
        for j = 1:k
            if old == j-1
                res(m,n) = new_gray_levels(j,1)
            end
        end
    end
end
figure();
xname('Equalised_Histogram image');
imshow(uint8(res));
imwrite(uint8(res),'equal_hist_img.jpg');
[count, cells]=imhist(uint8(res));

count = count/(k*k);
x= [0:1:(k-1)]';
figure();
title('Equalised_Histogram');
plot2d3(x,[count]);
